using System;
using System.Collections.Generic;
using UnityEngine;

namespace NowGG.Sdk
{
    public class NowGGAdsManager : AndroidJavaProxy, NowGGRewardsListener
    {

        public Action OnInitSuccess { get; set; }
        public Action<string> OnInitFailed { get; set; }
        public Action OnNowGGRewardedAdShownToUser { get; set; }
        public Action<string> OnNowGGRewardedAdFailedToLoad { get; set; }
        public Action<bool> OnNowGGRewardedAdDismissed { get; set; }
        public Action OnUserEarnedReward { get; set; }

        public bool IsInitialized { get; set; }
        AndroidJavaObject nowGGAndroidJavaObj;

        private static NowGGAdsManager instance;
        public static NowGGAdsManager Instance
        {
            get
            {
                NowGGLogger.Log("Initialising NowGGAdsManager");
                if (instance == null)
                {
                    instance = new NowGGAdsManager();
                }
                return instance;
            }
        }

        public NowGGAdsManager() : base("com.bluestacks.rewards.unity.UnityCallBack")
        {
        }

        public void Initialize()
        {

            nowGGAndroidJavaObj = new AndroidJavaObject("com.bluestacks.rewards.unity.NowGGRewardsSDK");

#if !UNITY_EDITOR
            AndroidJavaClass player = new  AndroidJavaClass("com.unity3d.player.UnityPlayer");
            AndroidJavaObject activity = player.GetStatic<AndroidJavaObject>("currentActivity");
            nowGGAndroidJavaObj.Call("initialize", activity, this);
#else

            OnNowGGAdsInitSuccess("success");
#endif
        }

        public void EnableDebugMode()
        {
            nowGGAndroidJavaObj = new AndroidJavaObject("com.bluestacks.rewards.unity.NowGGRewardsSDK");
#if !UNITY_EDITOR
            nowGGAndroidJavaObj.Call("enableDebugMode");
#endif
        }

        public void ShowRewardedAd()
        {
#if !UNITY_EDITOR
            nowGGAndroidJavaObj.Call("showRewardedAd");
#endif
        }

        public void OnNowGGAdsInitFailed(string error)
        {
            NowGGLogger.Log("On init fail resp.." + error);
            IsInitialized = false;
            if (OnInitFailed != null)
                OnInitFailed(error);
        }

        public void OnNowGGAdsInitSuccess(string response)
        {
            NowGGLogger.Log("On init success.." + response);
            IsInitialized = true;

            if (OnInitSuccess != null)
                OnInitSuccess();
        }

        public void OnRewardedAdShownToUser()
        {
            NowGGLogger.Log("OnNowGGRewardsOnAdShownToUser");
            if (OnNowGGRewardedAdShownToUser != null)
                OnNowGGRewardedAdShownToUser();
        }

        public void OnRewardedAdFailedToLoad(string error)
        {
            NowGGLogger.Log("OnNowGGRewardsOnAdFailedToLoad" + error);

            if (OnNowGGRewardedAdFailedToLoad != null)
                OnNowGGRewardedAdFailedToLoad(error);
        }

        public void OnRewardedAdDismissed(bool rewardEarned)
        {
            NowGGLogger.Log("OnNowGGRewardsOnAdDismissed");
            if (OnNowGGRewardedAdDismissed != null)
                OnNowGGRewardedAdDismissed(rewardEarned);
        }

        public void OnRewardedUserEarnedReward()
        {
            NowGGLogger.Log("OnNowGGRewardsOnUserEarnedReward");

            if (OnUserEarnedReward != null)
                OnUserEarnedReward();
        }
    }
}

public interface NowGGRewardsListener
{
    void OnNowGGAdsInitSuccess(string response);
    void OnNowGGAdsInitFailed(string error);
    void OnRewardedAdShownToUser();
    void OnRewardedAdFailedToLoad(string error);
    void OnRewardedAdDismissed(bool rewardEarned);
    void OnRewardedUserEarnedReward();
}
