#if UNITY_PURCHASING_V4_OR_OLDER
using UnityEngine.Purchasing;
using UnityEngine.Purchasing.Extension;

namespace NowGG.Sdk
{
    public class NowGGPurchasingModule : AbstractPurchasingModule, IStoreConfiguration
    {
        internal class StoreInstance
        {
            internal string storeName { get; }
            internal IStore instance { get; }

            internal StoreInstance(string name, IStore instance)
            {
                NowGGLogger.Log($"Creating new store instance with name: {name}");
                storeName = name;
                this.instance = instance;
            }
        }

        private static NowGGPurchasingModule ModuleInstance;
        internal StoreInstance storeInstance { get; private set; }

        public static AbstractPurchasingModule Instance()
        {
            NowGGLogger.Log("Initializing v2.0.0 of the NowGG Purchasing module.");
            NowGGLogger.Log($"Getting Purchasing module instance");
            if (!NowGGPaymentsSdkManager.IsNowGGIapAvailable())
            {
                NowGGLogger.Log($"Not a nowgg platform. Returning StandardPurchasingModule");
                return StandardPurchasingModule.Instance();
            }

            if (ModuleInstance == null)
            {
                NowGGLogger.Log($"nowgg platform detected. Creating NowGGPurchasingModule instance");
                ModuleInstance = new NowGGPurchasingModule();
            }

            NowGGLogger.Log($"Returning NowGGPurchasingModule instance");
            return ModuleInstance;
        }

        public override void Configure()
        {
            NowGGLogger.Log($"Configure() called");
            BindConfiguration((NowGGStoreConfigurationInterface)new NowGGStoreConfiguration());

            BindExtension((NowGGStoreExtensionsInterface)new NowGGStoreExtensions());

            if (storeInstance == null)
            {
                NowGGLogger.Log($"storeInstance is null. Creating new instance");
                storeInstance = InstantiateStore();
                RegisterStore(storeInstance.storeName, storeInstance.instance);
            }
        }

        private StoreInstance InstantiateStore()
        {
            NowGGLogger.Log($"InstantiateStore() called");
            return new StoreInstance("nowggStore", InstantiateNowGGStore());
        }

        private IStore InstantiateNowGGStore()
        {
            BindNowGGConfigurations();
            BindNowGGExtension();

            NowGGLogger.Log($"Store configuration and extensions binded successfully");

            return new NowGGStore();
        }

        private void BindNowGGExtension()
        {
            BindExtension((NowGGStoreExtensionsInterface)new NowGGStoreExtensions());
        }

        private void BindNowGGConfigurations()
        {
            BindConfiguration((NowGGStoreConfigurationInterface)new NowGGStoreConfiguration());
        }
    }
}
#endif
