#if UNITY_PURCHASING_V5_OR_NEWER
using System.Collections.Generic;
using System.Linq;
using UnityEngine.Purchasing;

namespace NowGG.Sdk
{
    internal class NowGGCart : ICart
    {

        private readonly List<CartItem> _items;

        public NowGGCart(List<UnityEngine.Purchasing.Product> products)
        {
            _items = products.ToList().Select(p => new CartItem(p)).ToList();
            // There's also an implicit conversion Product -> CartItem, so you can do:
            // _items = products.Select(p => (CartItem)p).ToList();
        }

        public IReadOnlyList<CartItem> Items() => _items;
        
    }
}
#endif