#if UNITY_PURCHASING_V5_OR_NEWER
using System.Collections.Generic;
using UnityEngine.Purchasing;

namespace NowGG.Sdk
{
    internal class NowGGOrderInfo : IOrderInfo
    {
        public IAppleOrderInfo Apple  { get; } = null;
        public IGoogleOrderInfo Google{ get; } = null;

        public List<IPurchasedProductInfo> PurchasedProductInfo { get; set; }

        public string Receipt       { get; }
        public string TransactionID { get; }

        public NowGGOrderInfo(string receipt, string transactionId,
                            List<IPurchasedProductInfo> purchasedInfo = null)
        {
            Receipt        = receipt ?? string.Empty;
            TransactionID  = transactionId ?? string.Empty;
            PurchasedProductInfo = purchasedInfo ?? new List<IPurchasedProductInfo>();
        }
    }
}
#endif