#if UNITY_PURCHASING_V5_OR_NEWER
using System.Collections.Generic;
using UnityEngine.Purchasing;

namespace NowGG.Sdk
{
    public class NowGGStoreController 
    {
        public static StoreController Init(string paymentId)
        {
            var wrapper = new NowGGStoreV5Wrapper(paymentId);
            UnityIAPServices.AddNewCustomStore(wrapper);
            var storeController = UnityIAPServices.StoreController(NowGGStoreV5.StoreName);
            UnityIAPServices.AddNewExtendedProductService(NowGGStoreV5.StoreName, (baseService) => new NowGGProductService(baseService));

            NowGG.Sdk.NowGGPaymentsSdkManager.Instance.PaymentId = paymentId;
            NowGGLogger.Log($"NowGGStoreController initialized with paymentId: {paymentId}");
            return storeController;
        }
    }
}
#endif