#if UNITY_PURCHASING_V5_OR_NEWER
using UnityEngine.Purchasing;
using UnityEngine.Purchasing.Extension;

namespace NowGG.Sdk
{
    public class NowGGStoreV5Wrapper : IStoreWrapper
    {
        public Store instance { get; }
        public string name { get; }
        public string paymentId { get; }

        private readonly NowGGStoreV5 _store;

        public NowGGStoreV5Wrapper(string paymentId)
        {
            name = NowGGStoreV5.StoreName;
            _store = new NowGGStoreV5(paymentId);
            instance = _store;
            this.paymentId = paymentId;
            NowGGLogger.Log($"NowGGStoreV5Wrapper created for store: {name}");
        }

        public ConnectionState GetStoreConnectionState()
        {
            return _store.State;
        }
    }
}
#endif