// using System;
// using System.Collections.Generic;
// using System.Xml;
// using UnityEngine.Purchasing;
// using UnityEngine.Purchasing.Security;

// public class NowGGSubscriptionInfo : SubscriptionInfo
// {
//     private readonly string productId;

//     private readonly DateTime purchaseDate;

//     private readonly DateTime subscriptionExpireDate;

//     private readonly DateTime subscriptionCancelDate;

//     private readonly TimeSpan remainedTime;

//     private readonly string introductory_price;

//     private readonly TimeSpan introductory_price_period;

//     private readonly long introductory_price_cycles;

//     private readonly TimeSpan freeTrialPeriod;

//     private readonly TimeSpan subscriptionPeriod;

//     private readonly string free_trial_period_string;

//     private readonly string sku_details;

//     public SubscriptionInfo(string skuDetails, bool isAutoRenewing, DateTime purchaseDate, bool isFreeTrial, bool hasIntroductoryPriceTrial, bool purchaseHistorySupported, string updateMetadata)
//     {

//     }

//     public string getProductId()
//     {
//         return productId;
//     }

//     public DateTime getPurchaseDate()
//     {
//         return purchaseDate;
//     }

//     public Result isSubscribed()
//     {
//         return is_subscribed;
//     }

//     public Result isExpired()
//     {
//         return is_expired;
//     }

//     public Result isCancelled()
//     {
//         return is_cancelled;
//     }

//     public Result isFreeTrial()
//     {
//         return is_free_trial;
//     }

//     public Result isAutoRenewing()
//     {
//         return is_auto_renewing;
//     }

//     public TimeSpan getRemainingTime()
//     {
//         return remainedTime;
//     }

//     public Result isIntroductoryPricePeriod()
//     {
//         return is_introductory_price_period;
//     }

//     public TimeSpan getIntroductoryPricePeriod()
//     {
//         return introductory_price_period;
//     }

//     public string getIntroductoryPrice()
//     {
//         if (!string.IsNullOrEmpty(introductory_price))
//         {
//             return introductory_price;
//         }

//         return "not available";
//     }

//     public long getIntroductoryPricePeriodCycles()
//     {
//         return introductory_price_cycles;
//     }

//     public DateTime getExpireDate()
//     {
//         return subscriptionExpireDate;
//     }

//     public DateTime getCancelDate()
//     {
//         return subscriptionCancelDate;
//     }

//     public TimeSpan getFreeTrialPeriod()
//     {
//         return freeTrialPeriod;
//     }

//     public TimeSpan getSubscriptionPeriod()
//     {
//         return subscriptionPeriod;
//     }

//     public string getFreeTrialPeriodString()
//     {
//         return free_trial_period_string;
//     }

//     public string getSkuDetails()
//     {
//         return sku_details;
//     }

//     public string getSubscriptionInfoJsonString()
//     {
//         return MiniJson.JsonEncode(new Dictionary<string, object>
//         {
//             { "productId", productId },
//             { "is_free_trial", is_free_trial },
//             {
//                 "is_introductory_price_period",
//                 is_introductory_price_period == Result.True
//             },
//             { "remaining_time_in_seconds", remainedTime.TotalSeconds }
//         });
//     }

//     private DateTime nextBillingDate(DateTime billing_begin_date, TimeSpanUnits units)
//     {
//         if (units.days == 0.0 && units.months == 0 && units.years == 0)
//         {
//             return new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
//         }

//         DateTime dateTime = billing_begin_date;
//         while (DateTime.Compare(dateTime, DateTime.UtcNow) <= 0)
//         {
//             dateTime = dateTime.AddDays(units.days).AddMonths(units.months).AddYears(units.years);
//         }

//         return dateTime;
//     }

//     private TimeSpan accumulateIntroductoryDuration(TimeSpanUnits units, long cycles)
//     {
//         TimeSpan result = TimeSpan.Zero;
//         for (long num = 0L; num < cycles; num++)
//         {
//             result = result.Add(computePeriodTimeSpan(units));
//         }

//         return result;
//     }

//     private TimeSpan computePeriodTimeSpan(TimeSpanUnits units)
//     {
//         DateTime now = DateTime.Now;
//         return now.AddDays(units.days).AddMonths(units.months).AddYears(units.years)
//             .Subtract(now);
//     }

//     private double computeExtraTime(string metadata, double new_sku_period_in_seconds)
//     {
//         Dictionary<string, object> dictionary = (Dictionary<string, object>)MiniJson.JsonDecode(metadata);
//         long num = (long)dictionary["old_sku_remaining_seconds"];
//         long num2 = (long)dictionary["old_sku_price_in_micros"];
//         double totalSeconds = parseTimeSpan((string)dictionary["old_sku_period_string"]).TotalSeconds;
//         long num3 = (long)dictionary["new_sku_price_in_micros"];
//         return (double)num / totalSeconds * (double)num2 / (double)num3 * new_sku_period_in_seconds;
//     }

//     private TimeSpan parseTimeSpan(string period_string)
//     {
//         TimeSpan result;
//         try
//         {
//             return XmlConvert.ToTimeSpan(period_string);
//         }
//         catch (Exception)
//         {
//             if (period_string == null || period_string.Length == 0)
//             {
//                 return TimeSpan.Zero;
//             }

//             result = new TimeSpan(7, 0, 0, 0);
//         }

//         return result;
//     }

//     private TimeSpanUnits parsePeriodTimeSpanUnits(string time_span)
//     {
//         return time_span switch
//         {
//             "P1W" => new TimeSpanUnits(7.0, 0, 0),
//             "P1M" => new TimeSpanUnits(0.0, 1, 0),
//             "P3M" => new TimeSpanUnits(0.0, 3, 0),
//             "P6M" => new TimeSpanUnits(0.0, 6, 0),
//             "P1Y" => new TimeSpanUnits(0.0, 0, 1),
//             _ => new TimeSpanUnits(parseTimeSpan(time_span).Days, 0, 0),
//         };
//     }
// }