# NowGG SDK - Unity IAP Multi-Version Support Setup Complete

## What Was Created

### 1. Version-Specific Store Implementations

#### Unity IAP 4.x Support (existing)
- `NowGGStore.cs` - Store implementation for IAP 4.x
- `NowGGPurchasingModule.cs` - Module for IAP 4.x
- Protected by: `#if !UNITY_PURCHASING_V5_OR_NEWER`

#### Unity IAP 5.x Support (new)
- `NowGGStorev5/NowGGStorev5.cs` - Store implementation for IAP 5.x
- `NowGGStorev5/NowGGPurchasingModulev5.cs` - Module for IAP 5.x
- Protected by: `#if UNITY_PURCHASING_V5_OR_NEWER`

### 2. Automatic Version Detection

#### Editor Script
- `Core/Editor/NowGGIAPVersionDefineSymbol.cs`
- Automatically detects Unity IAP version on Unity startup
- Sets `UNITY_PURCHASING_V5_OR_NEWER` define symbol for IAP 5.x+
- Provides menu item: **NowGG SDK → Refresh IAP Version Detection**

#### Runtime Helper
- `NowGGStoreVersionDetector.cs`
- Provides `GetNowGGPurchasingModule()` to get the correct module
- Uses conditional compilation for zero-overhead selection

### 3. Documentation
- `README.md` - Complete usage guide and troubleshooting

## How To Use

Developers integrating your SDK should use:

```csharp
using NowGG.Sdk;
using UnityEngine.Purchasing;

public class IAPManager : IStoreListener
{
    void Start()
    {
        var builder = ConfigurationBuilder.Instance(
            NowGGStoreVersionDetector.GetNowGGPurchasingModule()
        );
        
        builder.AddProduct("product_id", ProductType.Consumable);
        UnityPurchasing.Initialize(this, builder);
    }
}
```

## What Happens Next

1. **On Unity Restart/Reimport**: The Editor script will run and detect the Unity IAP version
2. **Define Symbol Set**: `UNITY_PURCHASING_V5_OR_NEWER` will be added to Player Settings if IAP 5.x+ is detected
3. **Recompilation**: Unity will recompile scripts with the correct version active
4. **No Errors**: Only the compatible version will be compiled

## Current Status

⚠️ **Expected Behavior**: You may see compilation errors for `NowGGStore.cs` right now because:
- Unity IAP 5.x is currently installed in this project
- The define symbol `UNITY_PURCHASING_V5_OR_NEWER` hasn't been set yet
- The Editor script needs to run (happens on next Unity restart or domain reload)

✅ **To Resolve**: Simply restart Unity or manually run:
- Menu: **NowGG SDK → Refresh IAP Version Detection**

After this, the v4 files will be excluded from compilation and only v5 files will compile.

## Benefits

✅ **Single SDK Package**: Both versions in one package  
✅ **Automatic Detection**: No manual configuration needed  
✅ **Zero Breaking Changes**: Seamless Unity IAP upgrades  
✅ **Clean API**: One method to get the right module  
✅ **Future-Proof**: Easy to add more versions  

## File Structure

```
CustomStore/
├── NowGGStore.cs                      # v4 implementation
├── NowGGPurchasingModule.cs           # v4 module
├── NowGGStoreVersionDetector.cs       # Version helper
├── NowGGStorev5/                      # v5 implementations
│   ├── NowGGStorev5.cs
│   └── NowGGPurchasingModulev5.cs
└── README.md                          # User documentation

Core/Editor/
└── NowGGIAPVersionDefineSymbol.cs     # Auto-detection script
```

## Testing Recommendations

1. **Test with Unity IAP 4.x**:
   - Downgrade to Unity IAP 4.12.x or earlier
   - Restart Unity
   - Verify `UNITY_PURCHASING_V5_OR_NEWER` is removed from Player Settings
   - Verify v4 implementation compiles

2. **Test with Unity IAP 5.x**:
   - Upgrade to Unity IAP 5.0.x or later
   - Restart Unity  
   - Verify `UNITY_PURCHASING_V5_OR_NEWER` is added to Player Settings
   - Verify v5 implementation compiles

## Next Steps for SDK Maintainers

1. ✅ Version-specific implementations created
2. ✅ Conditional compilation set up
3. ✅ Auto-detection Editor script created
4. ✅ Documentation written
5. ⏭️ Test with both Unity IAP 4.x and 5.x projects
6. ⏭️ Update SDK changelog
7. ⏭️ Update integration guide for developers

---

**Implementation Date**: December 3, 2025  
**Unity IAP Versions Supported**: 4.x and 5.x  
**Conditional Compilation Symbol**: `UNITY_PURCHASING_V5_OR_NEWER`
