﻿
using System.Collections.Generic;
using UnityEngine;
using System.Linq;
using System;


namespace NowGG.Sdk
{

    [System.Serializable]
    public class Product
    {
        public string productId = string.Empty;
        public string title = string.Empty;
        public string type = string.Empty;
        public string priceCurrencyCode = string.Empty;
        public string description = string.Empty ;
        public string price = string.Empty ;
        public string priceAmountMicros = string.Empty ;
        public string freeTrialPeriod = string.Empty;
        public string introductoryPrice = string.Empty;
        public string introductoryPriceAmountMicros = string.Empty;
        public string introductoryPriceCycles = string.Empty;
        public string introductoryPricePeriod = string.Empty;
        public bool rewarded = false;
        public string subscriptionPeriod = string.Empty;
        public List<string> benefits = new List<string>();

#if UNITY_EDITOR
        public Product(string productID)
        {
            this.productId = productID;
            price = "0.01";
            priceCurrencyCode = "$";
        }
#endif
    }


    [System.Serializable]
    public class PurchasedProduct
    {
        public string orderId = string.Empty;
        public string packageName = string.Empty;
        public string productId = string.Empty;
        public long purchaseTime = 0;
        public string purchaseToken = string.Empty;
        public string developerPayload = string.Empty;
        public bool autoRenewing = false;
        public string originalJson = string.Empty;
        public string signature = string.Empty;
        public Product skuDetails;

        public string subscriptionStatus = string.Empty;
        public string subscriptionPeriod = string.Empty;
        public long expiryTimeMillis = 0;
        public long subscriptionPurchaseDateMillis = 0;

        public bool isAcknowledged;

        public PurchasedProduct(string productID)
        {
            this.productId = productID;
        }
    }

    public enum PurchaseProcessingResult
    {
        Complete = 0,
        Pending = 1
    }

    public enum ProductType
    {
        Consumable = 0,
        NonConsumable = 1,
        Subscription = 2
    }

    public class NowGGProductBuilder
    {
        private Dictionary<string, ProductType> productBuilder = new Dictionary<string, ProductType>();

        private static NowGGProductBuilder instance;
        public static NowGGProductBuilder Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new NowGGProductBuilder();
                }
                return instance;
            }
        }

        public void AddProduct(string productId, ProductType productType)
        {
            try
            {
                productBuilder.Add(productId, productType);
            }
            catch (Exception ex)
            {
                Debug.LogError($"Exception in adding product with key: {productId} and error is {ex}");
            }

        }

        public void Clear(){
          productBuilder.Clear();
        }

        public int GetProductCount()
        {
            return productBuilder.Count;
        }

        public ProductType GetProductType(string productId)
        {
            if (productBuilder.ContainsKey(productId))
                return productBuilder[productId];
            return ProductType.NonConsumable;
        }

        public string[] GetProductIdArray()
        {
            return productBuilder.Keys.ToArray();
        }

        public void AddAdditionalProducts(Dictionary<string, ProductType> additionalProductDict)
        {
            foreach (string key in additionalProductDict.Keys)
            {
                AddProduct(key, additionalProductDict[key]);
            }
        }
    }
}