using NowGG.Sdk;
using System.Collections;
using TMPro;
using UnityEngine;
using UnityEngine.Networking;

public class LoginHandler : MonoBehaviour
{
    // TODO: Replace your client id here
    private string CLIENT_ID = "W4UaiLOPp7e3NQlZRbFF$$01JE657JP9QD7EB6FMSGSXV7S1";
    public TMP_Text TextLoginDetails;

    public void Start()
    {
        NowGGLoginSdkManager.Instance.OnLoginSuccess += OnLoginSuccess;
        NowGGLoginSdkManager.Instance.OnLoginFailed += OnLoginFailed;
    }

    private void OnLoginSuccess(string email, string token, string hostUrl)
    {
        Utils.Log($"Login success with email: {email} and token is: {token}");
        string message = $"Email: {email}\nToken: {token.Substring(0, 10)}...";
        TextLoginDetails.text = message;

        StartCoroutine(VerifyToken(token, CLIENT_ID));
    }

    private void OnLoginFailed(int errorCode, string errorMsg)
    {
        if (errorCode == 1)
        {
            NowGGLoginSdkManager.Instance.AddNowGGAccount();
            TextLoginDetails.text = "Initiating Nowgg login";
            return;
        }
        else
        {
            Utils.LogError($"Login failed with error code: {errorCode} and message: {errorMsg}");
            string message = $"Login failed. Error code: {errorCode}, message: {errorMsg}";
            TextLoginDetails.text = message;
        }
    }

    public IEnumerator VerifyToken(string token, string client_id)
    {
        WWWForm form = new WWWForm();
        form.AddField("token_type", "id_token");
        form.AddField("token", token);
        form.AddField("client_id", client_id);

        UnityWebRequest www = UnityWebRequest.Post("https://now.gg/accounts/oauth2/v1/verify-token", form);
        yield return www.SendWebRequest();

        if (www.result != UnityWebRequest.Result.Success)
        {
            Utils.LogError($"Error in token verification: {www.error}");
        }
        else
        {
            Utils.Log($"token verification response: {www.downloadHandler.text}");
            TokenVerification resp = JsonUtility.FromJson<TokenVerification>(www.downloadHandler.text);
             if (resp != null)
                 TokenVerifyResponse(resp.userData);
        }
    }

    private void TokenVerifyResponse(UserDataVerified userDataVerified)
    {
        Utils.Log($"TokenVerifyResponse: User id: {userDataVerified.userId}");
        string userId = userDataVerified.userId;
        string name = userDataVerified.name;
        string email = userDataVerified.email;
        string picture = userDataVerified.picture;

        string message = $"Name: {name}\nemail: {email}\nuserId: {userId}";
        TextLoginDetails.text = message;
    }

    public void BtnLoginClicked()
    {
        NowGGLoginSdkManager.Instance.Login(CLIENT_ID);
    }

    public void BtnBackClicked()
    {
        Utils.LoadScene(Constants.SceneName.MainMenu);
    }
}
