using TMPro;
using UnityEngine;

public class MainMenuHandler : MonoBehaviour
{
    public TMP_Text TextVersionInfo;

    private void Start()
    {
        TextVersionInfo.text = $"Demo: {Application.version}\nSDK: {NowGG.Sdk.NowGGVersion.Version}";
    }

    public void BtnLoginClicked()
    {
        Utils.Log("Loading Login scene");
        Utils.LoadScene(Constants.SceneName.Login);
    }

    public void BtnPaymentsClicked()
    {
        Utils.Log("Loading Payments - Standard scene");
        Utils.LoadScene(Constants.SceneName.Payments);
    }

    public void BtnQuickPaymentsClicked()
    {
        Utils.Log("Loading Payments - Quick scene");
        Utils.LoadScene(Constants.SceneName.PaymentsQuick);
    }

    public void BtnAdsClicked()
    {
        Utils.Log("Loading Ads scene");
        Utils.LoadScene(Constants.SceneName.Ads);
    }

    public void BtnEventsClicked()
    {
        Utils.Log("Loading Events scene");
        Utils.LoadScene(Constants.SceneName.Events);
    }

}
